#!/bin/bash

PREFIX=/dns/zones

cd $PREFIX

# Separate directories for separate views
for EXTINT in external internal
do
	cd $EXTINT

	OUTFILE=$PREFIX/dns-$EXTINT-forward-zones.conf
	rm -f $OUTFILE	# Remove the old one

	# For FORWARD zones
	echo "Gathering FORWARD zones..."

	# Top-Level Domains
	for TLD in com net org
	do
		cd $TLD

		# Domains
		for DOMAIN in `ls -l | grep ^d | awk '{print $9}'`	# list directories only
		do
			cd $DOMAIN

			for FILE in `ls *.db`
			do
				ZONE=`echo $FILE | sed -e 's/.db//' `
				echo "adding $ZONE"

				echo "zone \"$ZONE\" in {"		>> $OUTFILE

				# Include options from .opt file in zone entry:
				if [ -f $FILE.opts ]; then

					if [ -z "`grep type $FILE.opts`" ]; then
						echo "  type master;"	>> $OUTFILE
					fi

					echo "Adding options for $ZONE"
					echo -n "  "			>> $OUTFILE
					cat $FILE.opts			>> $OUTFILE
				else
					echo "  type master;"		>> $OUTFILE
				fi


				echo "  file \"$EXTINT/$TLD/$DOMAIN/$FILE\"; };"	>> $OUTFILE
				echo ""					>> $OUTFILE
			done
			cd ..	# move out of $DOMAIN

		done
		cd ..	# move out of $TLD

	done

	# For REVERSE zones
	OUTFILE=$PREFIX/dns-$EXTINT-reverse-zones.conf
	rm -f $OUTFILE	# Remove the old one
	REVERSE="arpa/in-addr"
	cd $REVERSE

	echo "Gathering REVERSE zones..."

	for FILE in `ls *.db`
	do
		ZONE=`echo $FILE | sed -e 's/.db//' `
		echo "adding $ZONE"

		echo "zone \"$ZONE\" in {"			>> $OUTFILE
		#echo "  type master;"				>> $OUTFILE

		# Include options from .opt file in zone entry:
		if [ -f $FILE.opts ]; then

			if [ -z "`grep type $FILE.opts`" ]; then
				echo "  type master;"   >> $OUTFILE
			fi

			echo "Adding options for $ZONE"
			echo -n "  "				>> $OUTFILE
			cat $FILE.opts				>> $OUTFILE
		else
			echo "  type master;"			>> $OUTFILE
		fi

		echo "  file \"$EXTINT/$REVERSE/$FILE\"; };"	>> $OUTFILE
		echo ""						>> $OUTFILE
	done

	cd ../..	# move out of $REVERSE (2 dirs.)
	cd ..		# move out of $EXTINT
done
