#!/bin/bash

# This script expects to have passwordless
# in place to call rsync.

export PATH=/bin:/usr/bin:/usr/local/bin:

RSYNC=`which rsync`
SSH=`which ssh`
DATE=`which date`
DESTSERVERLIST="172.16.25.100 172.16.25.101"

echo "===> rsync started at " `$DATE`

for DESTSERVER in $DESTSERVERLIST
do
	echo "Syncing named.conf to $DESTSERVER"
	$RSYNC -avuzb -e $SSH /dns/etc/named.conf root@$DESTSERVER:/dns/etc/
	echo "Syncing zones for $DESTSERVER"
	$RSYNC -avuz --delete -e $SSH /dns/zones/ root@$DESTSERVER:/dns/zones/
	echo "Syncing scripts for $DESTSERVER"
	$RSYNC -avuz --delete -e $SSH /dns/scripts/ root@$DESTSERVER:/dns/scripts/
	echo " "
done

echo "===> rsync finished at " `$DATE`
