#
# set-named-perms.sh
#
#   Set the ownership and permissions on the named directory
#

cd /dns


# By default, root owns everything and only root can write, but dirs
# have to be executable too. Note that some platforms use a colon
# instead of a dot between user/group in the chown parameters}

chown -R root:named .

# regular files
find . -type f -print | grep -v bin | grep -v scripts | xargs chmod 644  

# directories
find . -type d -print | xargs chmod 755

# the named.conf and rndc.conf must protect their keys
chmod o= etc/*.conf

# the "secondaries" directory is where we park files from
# master nameservers, and named needs to be able to update
# these files and create new ones.

touch etc/secondaries/.empty  # placeholder
find etc/secondaries/ -type f -print | xargs chown named:named
find etc/secondaries/ -type f -print | xargs chmod ug=r,o=

chown root:named etc/secondaries/
chmod 770  etc/secondaries/

# the var/run business is for the PID file
chown root:root  var/
chmod 711 var/

chown root:named  var/run/
chmod 775 var/run/

# named has to be able to create logfiles
chown root:named logs/
chmod 775 logs/

# set perms on zone files
chown -R root:named zones/
chmod -R 775 zones/
